VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsCRC32"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Private CRC32Table(0 To 255) As Long
Private Const CRC32_POLYNOMIAL As Long = &HED69102

Public Function CRC32(ByVal Data As String) As Long
    Dim i As Long, j As Long
    
    Call InitCRC32
    
    CRC32 = &HFFFFFFFF
    
    For i = 1 To Len(Data)
        j = CByte(Asc(Mid(Data, i, 1))) Xor (CRC32 And &HFF&)
        If CRC32 < 0 Then CRC32 = ((CRC32 And &H7FFFFFFF) \ &H100&) Or &H800000 Else CRC32 = CRC32 \ &H100&
        CRC32 = CRC32 Xor CRC32Table(j)
    Next
    
    CRC32 = Not CRC32
End Function

Private Sub InitCRC32()
    Dim i As Long, j As Long, k As Long, XorVal As Long
    
    Static CRC32Initialized As Boolean
    If CRC32Initialized Then Exit Sub
    CRC32Initialized = True
    
    For i = 0 To 255
        k = i
        
        For j = 1 To 8
            If k And 1 Then XorVal = CRC32_POLYNOMIAL Else XorVal = 0
            If k < 0 Then k = ((k And &H7FFFFFFF) \ 2) Or &H40000000 Else k = k \ 2
            k = k Xor XorVal
        Next
        
        CRC32Table(i) = k
    Next
End Sub
